import { StyleSheet, Text, View } from "react-native";
import React from "react";
import { itemDetailsStyles } from "../ItemDetailsStyle";
import usePreferences from "../../../../../../hooks/usePreferences"
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";

const B2bPrices = ({item, width}) => {
    const {company: {dflt_currency_symbol} = {}} = usePreferences();
  return (
    <View style={B2bPricesStyles.cont(width)}>
        {item?.price && 
            item?.min_qty && 
            item?.max_qty && 
            <>
                <Text style={itemDetailsStyles.price}>{`${dflt_currency_symbol}${item?.price}`}</Text>
                <Text style={B2bPricesStyles.qty}>{`${item?.min_qty} - ${item?.max_qty} pieces`}</Text>
            </>
        }
    </View>
  );
};

export default B2bPrices;

export const B2bPricesStyles = StyleSheet.create({
    cont: (width) => ({
        width: width,
        marginRight: dpr(10)
    }),
    qty: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#898989",
    }
});
